import numpy as np
import os

import yaml


class Config(object):
    def __init__(self, args):
        self.dataset_name = args['dataset_name']
        self.lr = args['opt']['lr']
        # self.lr_str = args.lr
        self.num_iters = args['opt']['num_iters']
        self.weight_decay = args['opt']['weight_decay']
        self.num_classes = args['dataset']['num_classes']
        self.modal = args['dataset']['modal']
        self.len_feature = args['model']['len_feature']
        self.real_batch_size = args['dataset']['rel_batch_size']
        self.batch_size = args['dataset']['batch_size']
        self.data_path = args['dataset']['data_path']
        self.model_path = args['dataset']['model_path']
        self.output_path = args['dataset']['output_path']
        self.gt_path = args['dataset']['gt_path']
        self.log_path = args['dataset']['log_path']
        self.num_workers = args['dataset']['num_workers']
        self.lambdas = args['model']['lambdas']
        self.r_act = args['model']['r_act']
        self.class_thresh = args['model']['class_th']
        self.act_thresh_cas = np.arange(args['val']['act_thresh_cas'][0], args['val']['act_thresh_cas'][1], args['val']['act_thresh_cas'][2])
        self.act_thresh_agnostic = np.arange(args['val']['act_thresh_agnostic'][0], args['val']['act_thresh_agnostic'][1], args['val']['act_thresh_agnostic'][2])
        # self.act_thresh_cas = np.arange(0.025, 0.225, 0.025)
        # self.act_thresh_agnostic = np.arange(0.025, 0.975, 0.025)
        self.scale = args['model']['scale']
        self.model_file = args['dataset']['model_file']
        self.seed = args['dataset']['seed']
        self.feature_fps = args['dataset']['feature_fps']
        self.search_freq = args['model']['search_freq']
        self.budget = args['model']['budget']
        self.num_segments = args['dataset']['sample_len']
        self.val_per_epoch = args['val']['val_per_epoch']
        self.final_proposals_NMS = args['val']['final_proposals_NMS']
        self.n_jobs = args['model']['n_jobs']
        self.sampling_type = args['dataset']['sampling_type']
        self.th_similar_min = args['model']['th_similar_min']
        self.th_different_max = args['model']['th_different_max']
        
    def __str__(self):
        attrs = vars(self)
        attr_lst = sorted(attrs.keys())
        return '\n'.join("- %s: %s" % (item, attrs[item]) for item in attr_lst if item != 'lr')


def load_config(config_file, defaults=None):
    with open(config_file, "r") as fd:
        config = yaml.load(fd, Loader=yaml.FullLoader)
    return config

class_dict = {0: 'BaseballPitch',
                1: 'BasketballDunk',
                2: 'Billiards',
                3: 'CleanAndJerk',
                4: 'CliffDiving',
                5: 'CricketBowling',
                6: 'CricketShot',
                7: 'Diving',
                8: 'FrisbeeCatch',
                9: 'GolfSwing',
                10: 'HammerThrow',
                11: 'HighJump',
                12: 'JavelinThrow',
                13: 'LongJump',
                14: 'PoleVault',
                15: 'Shotput',
                16: 'SoccerPenalty',
                17: 'TennisSwing',
                18: 'ThrowDiscus',
                19: 'VolleyballSpiking'}

class_dict_activityNet = [
'Applying sunscreen', 'Archery', 'Arm wrestling', 'Assembling bicycle',
                    'BMX', 'Baking cookies', 'Ballet', 'Bathing dog', 'Baton twirling',
                    'Beach soccer', 'Beer pong', 'Belly dance', 'Blow-drying hair', 'Blowing leaves',
                    'Braiding hair', 'Breakdancing', 'Brushing hair', 'Brushing teeth', 'Building sandcastles',
                    'Bullfighting', 'Bungee jumping', 'Calf roping', 'Camel ride', 'Canoeing', 'Capoeira',
                    'Carving jack-o-lanterns', 'Changing car wheel', 'Cheerleading', 'Chopping wood',
                    'Clean and jerk', 'Cleaning shoes', 'Cleaning sink', 'Cleaning windows', 'Clipping cat claws',
                    'Cricket', 'Croquet', 'Cumbia', 'Curling', 'Cutting the grass', 'Decorating the Christmas tree',
                    'Disc dog', 'Discus throw', 'Dodgeball', 'Doing a powerbomb', 'Doing crunches', 'Doing fencing',
                    'Doing karate', 'Doing kickboxing', 'Doing motocross', 'Doing nails', 'Doing step aerobics',
                    'Drinking beer', 'Drinking coffee', 'Drum corps', 'Elliptical trainer', 'Fixing bicycle', 'Fixing the roof',
                    'Fun sliding down', 'Futsal', 'Gargling mouthwash', 'Getting a haircut', 'Getting a piercing', 'Getting a tattoo',
                    'Grooming dog', 'Grooming horse', 'Hammer throw', 'Hand car wash', 'Hand washing clothes', 'Hanging wallpaper',
                    'Having an ice cream', 'High jump', 'Hitting a pinata', 'Hopscotch', 'Horseback riding', 'Hula hoop',
                    'Hurling', 'Ice fishing', 'Installing carpet', 'Ironing clothes', 'Javelin throw', 'Kayaking', 'Kite flying',
                    'Kneeling', 'Knitting', 'Laying tile', 'Layup drill in basketball', 'Long jump', 'Longboarding',
                    'Making a cake', 'Making a lemonade', 'Making a sandwich', 'Making an omelette', 'Mixing drinks',
                    'Mooping floor', 'Mowing the lawn', 'Paintball', 'Painting', 'Painting fence', 'Painting furniture',
                    'Peeling potatoes', 'Ping-pong', 'Plastering', 'Plataform diving', 'Playing accordion', 'Playing badminton',
                    'Playing bagpipes', 'Playing beach volleyball', 'Playing blackjack', 'Playing congas', 'Playing drums',
                    'Playing field hockey', 'Playing flauta', 'Playing guitarra', 'Playing harmonica', 'Playing ice hockey',
                    'Playing kickball', 'Playing lacrosse', 'Playing piano', 'Playing polo', 'Playing pool', 'Playing racquetball',
                    'Playing rubik cube', 'Playing saxophone', 'Playing squash', 'Playing ten pins', 'Playing violin',
                    'Playing water polo', 'Pole vault', 'Polishing forniture', 'Polishing shoes', 'Powerbocking', 'Preparing pasta',
                    'Preparing salad', 'Putting in contact lenses', 'Putting on makeup', 'Putting on shoes', 'Rafting',
                    'Raking leaves', 'Removing curlers', 'Removing ice from car', 'Riding bumper cars', 'River tubing',
                    'Rock climbing', 'Rock-paper-scissors', 'Rollerblading', 'Roof shingle removal', 'Rope skipping',
                    'Running a marathon', 'Sailing', 'Scuba diving', 'Sharpening knives', 'Shaving', 'Shaving legs',
                    'Shot put', 'Shoveling snow', 'Shuffleboard', 'Skateboarding', 'Skiing', 'Slacklining',
                    'Smoking a cigarette', 'Smoking hookah', 'Snatch', 'Snow tubing', 'Snowboarding', 'Spinning',
                    'Spread mulch','Springboard diving', 'Starting a campfire', 'Sumo', 'Surfing', 'Swimming',
                    'Swinging at the playground', 'Table soccer','Tai chi', 'Tango', 'Tennis serve with ball bouncing',
                    'Throwing darts', 'Trimming branches or hedges', 'Triple jump', 'Tug of war', 'Tumbling', 'Using parallel bars',
                    'Using the balance beam', 'Using the monkey bar', 'Using the pommel horse', 'Using the rowing machine',
                    'Using uneven bars', 'Vacuuming floor', 'Volleyball', 'Wakeboarding', 'Walking the dog', 'Washing dishes',
                    'Washing face', 'Washing hands', 'Waterskiing', 'Waxing skis', 'Welding', 'Windsurfing', 'Wrapping presents',
                    'Zumba']

# print(len(class_dict))
class_dict_A = {}
for i in range(len(class_dict_activityNet)):
    class_dict_A[i] = class_dict_activityNet[i]


class_dict_gtea = {0: 'stir',
                1: 'open',
                2: 'put',
                3: 'close',
                4: 'take',
                5: 'pour',
                6: 'scoop'}

class_dict_b = ['rinse_cup', 'move_rest', 'take_cup', 'open_door', 'move_seat', 'pull_drawer', 'insert_wire', 'place_tape', 'plug_plug', 'pour_spoon', 'pull-out_weight-pin', 'switch-on_socket', 'fill_cup', 'push_rowing-machine', 'press_button', 'pick-up_cup', 'insert_weight-pin', 'insert_foot', 'scoop_spoon', 'take_spoon', 'turn_tap', 'pick-up_plug', 'hold-down_button', 'rotate_weight-setting', 'open_jar', 'let-go_rowing-machine', 'put_jar', 'pull_rowing-machine', 'stir_spoon', 'put_cup', 'scan_card-reader', 'push_drawer', 'pick-up_jar', 'pick-up_tape']
class_dict_beoid = {}
for i in range(len(class_dict_b)):
    class_dict_beoid[i] = class_dict_b[i]